/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.ponder.foundation.registration;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nullable;
import net.createmod.ponder.Ponder;
import net.createmod.ponder.api.level.PonderLevel;
import net.createmod.ponder.api.registration.SceneRegistryAccess;
import net.createmod.ponder.api.registration.StoryBoardEntry;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.foundation.PonderIndex;
import net.createmod.ponder.foundation.PonderScene;
import net.createmod.ponder.foundation.registration.PonderLocalization;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_5425;
import net.minecraft.class_7871;
import net.minecraft.class_7923;

public class PonderSceneRegistry
implements SceneRegistryAccess {
    private final PonderLocalization localization;
    private final Multimap<class_2960, StoryBoardEntry> scenes;
    private boolean allowRegistration = true;

    public PonderSceneRegistry(PonderLocalization localization) {
        this.localization = localization;
        this.scenes = LinkedHashMultimap.create();
    }

    public void clearRegistry() {
        this.scenes.clear();
        this.allowRegistration = true;
    }

    public void addStoryBoard(StoryBoardEntry entry) {
        if (!this.allowRegistration) {
            throw new IllegalStateException("Registration Phase has already ended!");
        }
        this.scenes.put((Object)entry.getComponent(), (Object)entry);
    }

    @Override
    public Collection<Map.Entry<class_2960, StoryBoardEntry>> getRegisteredEntries() {
        return this.scenes.entries();
    }

    @Override
    public boolean doScenesExistForId(class_2960 id) {
        return this.scenes.containsKey((Object)id);
    }

    @Override
    public List<PonderScene> compile(class_2960 id) {
        Collection entries;
        if (PonderIndex.editingModeActive()) {
            PonderIndex.reload();
        }
        if ((entries = this.scenes.get((Object)id)).isEmpty()) {
            return Collections.emptyList();
        }
        return this.compile(entries);
    }

    @Override
    public List<PonderScene> compile(Collection<StoryBoardEntry> entries) {
        if (PonderIndex.editingModeActive()) {
            this.localization.clearShared();
            PonderIndex.gatherSharedText();
        }
        ArrayList<PonderScene> scenes = new ArrayList<PonderScene>();
        for (StoryBoardEntry storyBoard : entries) {
            class_3499 activeTemplate = PonderSceneRegistry.loadSchematic(storyBoard.getSchematicLocation());
            PonderLevel level = new PonderLevel(class_2338.field_10980, (class_1937)class_310.method_1551().field_1687);
            activeTemplate.method_15172((class_5425)level, class_2338.field_10980, class_2338.field_10980, new class_3492(), level.field_9229, 2);
            level.createBackup();
            PonderScene scene = PonderSceneRegistry.compileScene(this.localization, storyBoard, level);
            scene.begin();
            scenes.add(scene);
        }
        return scenes;
    }

    public static PonderScene compileScene(PonderLocalization localization, StoryBoardEntry sb, @Nullable PonderLevel level) {
        PonderScene scene = new PonderScene(level, localization, sb.getNamespace(), sb.getComponent(), sb.getTags(), sb.getOrderingEntries());
        SceneBuilder builder = scene.builder();
        sb.getBoard().program(builder, scene.getSceneBuildingUtil());
        return scene;
    }

    public static class_3499 loadSchematic(class_2960 location) {
        return PonderSceneRegistry.loadSchematic(class_310.method_1551().method_1478(), location);
    }

    public static class_3499 loadSchematic(class_3300 resourceManager, class_2960 location) {
        class_3499 class_34992;
        block9: {
            String path;
            String namespace = location.method_12836();
            class_2960 location1 = new class_2960(namespace, path = "ponder/" + location.method_12832() + ".nbt");
            Optional optionalResource = resourceManager.method_14486(location1);
            if (optionalResource.isEmpty()) {
                Ponder.LOGGER.error("Ponder schematic missing: " + location1);
                return new class_3499();
            }
            class_3298 resource = (class_3298)optionalResource.get();
            InputStream inputStream = resource.method_14482();
            try {
                class_34992 = PonderSceneRegistry.loadSchematic(inputStream);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Ponder.LOGGER.error("Failed to read ponder schematic: " + location1, (Throwable)e);
                    return new class_3499();
                }
            }
            inputStream.close();
        }
        return class_34992;
    }

    public static class_3499 loadSchematic(InputStream resourceStream) throws IOException {
        class_3499 t = new class_3499();
        DataInputStream stream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(resourceStream)));
        class_2487 nbt = class_2507.method_10625((DataInput)stream, (class_2505)new class_2505(0x20000000L));
        t.method_15183((class_7871)class_7923.field_41175.method_46771(), nbt);
        return t;
    }
}

